"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

var _path = _interopRequireDefault(require("path"));

var _koa = _interopRequireDefault(require("koa"));

var _koaStatic = _interopRequireDefault(require("koa-static"));

var _record = require("./middleware/record");

var _bundle = _interopRequireDefault(require("./routes/bundle"));

var _debug = _interopRequireDefault(require("./routes/debug"));

var app = new _koa["default"](); // 静态服务

app.use((0, _koaStatic["default"])(_path["default"].join(__dirname, 'public'))); // record

app.use(_record.record); // 路由

app.use(_bundle["default"].routes(), _bundle["default"].allowedMethods());
app.use(_debug["default"].routes(), _bundle["default"].allowedMethods()); // 配置静态web服务的中间件

app.on('error', function (err, ctx) {
  console.error("### App Server ### \u670D\u52A1\u5668\u9519\u8BEF: ".concat(err.message));
  var errMsg = "\u51FA\u9519\u4E86!HTTP error code: ".concat(err.status, ", \u51FA\u9519\u4FE1\u606F: ").concat(err.message);

  if (ctx) {
    ctx.body = errMsg;
  }
});
module.exports = app;