
const path = require('path')
const fs = require('fs')
const { exec } = require('child_process')
const debuglog = require('./debuglog')

/**
 * 启动window平台的chrome
 */
function lookupChromeWindows () {
  return new Promise((resolve, reject) => {
    let chromePath
    const chromeSysRegHKey = '"HKEY_LOCAL_MACHINE\\SOFTWARE\\Microsoft\\Windows\\CurrentVersion\\App Paths\\chrome.exe" /v path'
    exec(`REG QUERY ${chromeSysRegHKey}`, (err, stdout, stderr) => {
      if (err) {
        chromePath = downgradLookup()
        if (!chromePath) {
          return reject(err)
        }
        else {
          return resolve(chromePath)
        }
      }

      chromePath = parseChromePathFromRegOutput(stdout, stderr)
      if (!chromePath) {
        return reject(new Error(`无法解析Reg Query输出`))
      }
      return resolve(chromePath)
    })
  }).catch(err => {
    return err
  })
}

function downgradLookup () {
  let chromePath
  const suffix = '\\Google\\Chrome\\Application\\chrome.exe'
  const prefixes = [
    process.env.LOCALAPPDATA,
    process.env.PROGRAMFILES,
    process.env['PROGRAMFILES(X86)']
  ]
  for (const prefix of prefixes) {
    try {
      chromePath = path.join(prefix, suffix)
      fs.accessSync(chromePath)
      break
    }
    catch (err) {}
  }
  debuglog(`downgradeLookup(): chromePath: ${chromePath}`)
  return chromePath
}

function parseChromePathFromRegOutput (stdout, stderr) {
  const lines = stdout.split('\n')
  let testPath, chromePath
  lines.every(line => {
    const targLine = line.match(/path\s+reg_sz\s+(.+)/i)
    if (targLine) {
      testPath = targLine[1]
      return false
    }
    return true
  })
  try {
    testPath = path.resolve(testPath, 'chrome.exe')
    fs.accessSync(testPath)
    chromePath = testPath
  }
  catch (err) {}
  return chromePath
}

module.exports = lookupChromeWindows
