
const { exec } = require('child_process')
const fs = require('fs')
const path = require('path')

/**
 * 查找mac平台的chrome
 */
function lookupChromeMac() {
  const bundles = ['com.google.Chrome.canary', 'com.google.Chrome']
  function mdFind() {
    return new Promise((resolve, reject) => {
      exec(`mdfind 'kMDItemCFBundleIdentifier=${bundles[0]}'`, (err, stdout, stderr) => {
        const chromePath = stdout.trim()
        if(!err && fs.existsSync(chromePath)) {
          resolve(path.join(chromePath, `/Contents/MacOS/${path.basename(chromePath, '.app')}`))
        }
        else {
          bundles.shift()
          if(bundles[0]){
            mdFind().then(resolve, reject)
          }
          else {
            reject(err)
          }
        }
      })
    })
  }
  return mdFind()
}

module.exports = lookupChromeMac
