# adb-commander

[![tested with jest](https://img.shields.io/badge/tested_with-jest-99424f.svg)](https://github.com/facebook/jest)
[![code style: prettier](https://img.shields.io/badge/code_style-prettier-ff69b4.svg?style=flat-square)](https://github.com/prettier/prettier)

provide adb(Android Debug Bridge) command functions

## Examples

### deviceList

```javascript
const adbCommander = require('adb-commander')

adbCommander.deviceList().then((deviceList, err) => {
  if (err) {
    console.error('fail to execute adb devices')
    return
  }
  if (deviceList.length > 0) {
    console.info(`devices is ${deviceList.join(',')}`)
  }
})
```

### install and isInstalled

```javascript

const adbCommander = require('adb-commander')

adbCommander.install(apkPath)
    .then(({ result, err }) => {
        if (err) {
            console.error('install failed')
        }
        adbCommander.isInstalled(deviceSn, 'org.hapjs.debugger').then(({isInstalled, err }) => {
            if(isInstalled === true){
                console.log('org.hapjs.debugger is installed')
            }
        })

     })
)

```

### unInstall

```javascript

const adbCommander = require('adb-commander')

adbCommander.uninstall( deviceSn, 'org.hapjs.debugger')
    .then(({ result, err }) => {
        if (err) {
            console.error('uninstall failed')
        }
        adbCommander.isInstalled(deviceSn, 'org.hapjs.debugger').then(({isInstalled, err }) => {
            if(isInstalled === false){
                console.log('org.hapjs.debugger is uninstalled')
            }
        })
     })
)

```

### startActivity

#### params

- deviceSn `string`
- action `string` optional
- component `string` optional
- extra `[{key: string, type: string, value: <any>}, ...]` optional

```javascript
const adbCommander = require('adb-commander')

adbCommander
  .startActivity(deviceSn, action, component, extra)
  .then(({ result, err }) => {
    if (err) {
      console.error('startActivity failed')
      return
    }
    console.log('start activity result', { result, err })
  })
```

### exeCommand 执行 adb 命令

```javascript
const adbCommander = require('adb-commander')

adbCommander.exeCommand('adb devices').then(({ result, err }) => {
  if (err) {
    console.error("exeCommand 'adb devices' failed")
    return
  }
  console.log('adb devices result', { result, err })
})
```
