#!/usr/bin/env node

const program = require('commander')
const chalk = require('chalk')
const version = require('../package.json').version

program
  .version(version, '-v, --version')
  .usage('<command> [options]')

program
  .command('server')
  .description('open server for project')
  .option('--port <port>', 'specified port', 3000)
  .option('--watch', 'recompile project while file changes')
  .action(options => {
    const startServer = require('../lib/commands/server')
    options.server = true
    startServer(options, 'dev')
  })

program
  .command('build')
  .description('build the project')
  .option('--disable-subpackages', 'disable subpackages')
  .option('--disable-stream-pack', 'disable stream pack')
  .option('--copy-rpk', 'copy rpk')
  .option('--cocos-wx-game', 'compile cocosWxGame')
  .option('--strict-mode', 'strict mode')
  .option('--ignore [folders]', 'exclude folders')
  .option('--include-file-ext [fileExts]', 'include file exts')
  .action(options => {
    const compile = require('../lib/commands/compile')
    compile(options, 'dev')
  })

program
  .command('release')
  .description('release the project')
  .option('--disable-subpackages', 'disable subpackages')
  .option('--disable-stream-pack', 'disable stream pack')
  .option('--copy-rpk', 'copy rpk')
  .option('--cocos-wx-game', 'compile cocosWxGame')
  .option('--strict-mode', 'strict mode')
  .option('--ignore [folders]', 'exclude folders')
  .option('--include-file-ext [fileExts]', 'include file exts')
  .action(options => {
    const compile = require('../lib/commands/compile')
    compile(options, 'prod')
  })

program
  .command('watch')
  .description('recompile project while file changes')
  .option('--disable-subpackages', 'disable subpackages')
  .action(options => {
    const compile = require('../lib/commands/compile')
    options.watch = true
    compile(options, 'dev')
  })

program
  .command('debug')
  .description('generate debug url for game.')
  .option('--print-only', 'Only print the debugger URL.')
  .option('--use-desktopbundled', 'Use chrome destkop bundled devtools')
  .action(options => {
    const debug =  require('../lib/commands/debug')
    debug(options, '')
  })

program.on('--help', () => {
  console.log()
  console.log(`  Run ${chalk.cyan('hg <command> --help')} for detailed usage of given command.`)
  console.log()
})

program.parse(process.argv)
