## quickgame-cli

**快游戏开发者工具**

**升级npm到5.2.0+以上,nodejs安装 8.1.4+**

### 安装

`npm install quickgame -D`

注意：微信小游戏编译成快游戏，请先执行 [npx create-quickgame](https://www.npmjs.com/package/create-quickgame)初始化项目后再安装此工具

### 使用

#### 1、编译

**1）编译debug版本**

```shell
npm run build
```

**2）编译release版本（release包需要release签名： [生成release签名](https://doc.quickapp.cn/tools/compiling-tools.html)）**

```shell
npm run release
```

**3）自动监听文件，编译debug版本**

```shell
npm run watch
```

#### 4) 命令行参数说明

**`--ignore [folders]`: 忽略不需要打包的文件(目前只支持排除文件夹)**

```shell
// 忽略 test 文件夹
npm run build -- --ignore test
// 忽略 test src 等多个文件夹（用逗号隔开）
npm run build -- --ignore test,src
```

**`--disable-subpackages`:  关闭分包行为(在前提下默认开启)**

前提：在manifest.json文件中配置过分包功能且`minPlatformVersion>=1040`情况下，默认开启分包功能

**`--disable-stream-pack`:  关闭流式打包(默认开启)**

**`--cocos-wx-game`:  编译时声明来自cocos IDE产出的微信小游戏**

**注：完成 `npx create-quickgame `初始化构建操作后，cocos游戏编译成快游戏，需要在命令行后添加参数`--cocos-wx-game`，如：`npm run build -- --cocos-wx-game` 或者 `npx quickgame build --cocos-wx-game`**




#### 2、启动服务

**1）启动本地服务**

```shell
npm run server
```

**注：当端口号被占时，使用指定端口：`npm run server -- --port 4000`**



#### 3、本地调试

##### 1）环境要求

* **chrome浏览器**

##### 2）启动调试服务

* **打开游戏运行界面**
* **手机 USB 连接到 PC**
* **执行命令：`npm run debug` 会在chrome浏览器中自动启动调试界面**
  * **如果希望手动打开调试界面：`npm run debug -- --print-only` 将命令行中的`Debugger URL`地址粘贴到chrome浏览器中打开**

**[注]：严格按照先运行游戏再启动调试功能的先后顺序**

![image-20190408181521717](https://i.loli.net/2019/04/12/5cb04f5337b6e.png)



### 常见问题

#####  1、 `npm install  `安装失败

* **解决方式：执行`npm cache clean --force` 清除npm缓存造成的影响**