require "luaScript/CocoStudioTest/CocoStudioGUITest/CocoStudioGUITest"
require "luaScript/CocoStudioTest/CocoStudioSceneTest/CocoStudioSceneTest"
require "luaScript/CocoStudioTest/CocoStudioArmatureTest/CocoStudioArmatureTest"

local LINE_SPACE = 40
local ITEM_TAG_BASIC = 1000

local cocoStudioTestItemNames = 
{
    {
        itemTitle = "CocoStudioArmatureTest",
        testScene = function () 
            runArmatureTestScene()
        end
    },

    {
        itemTitle = "CocoStudioGUITest",
        testScene =  function () 
            runCocosGUITestScene()
        end
    },

    {
        itemTitle = "CocoStudioSceneTest",
        testScene = function () 
            runCocosSceneTestScene()
        end
    },
} 

local CocoStudioTestScene = class("CocoStudioTestScene")
CocoStudioTestScene.__index = CocoStudioTestScene

function CocoStudioTestScene.extend(target)
    local t = tolua.getpeer(target)
    if not t then
        t = {}
        tolua.setpeer(target, t)
    end
    setmetatable(t, CocoStudioTestScene)
    return target
end

function CocoStudioTestScene:runThisTest()

    --armatureSceneIdx   = ArmatureTestIndex.TEST_COCOSTUDIO_WITH_SKELETON
    --self:addChild(restartArmatureTest())
end

function CocoStudioTestScene.create()
    local scene = CocoStudioTestScene.extend(CCScene:create())
    return scene   
end

local CocoStudioTestLayer = class("CocoStudioTestLayer")
CocoStudioTestLayer.__index = CocoStudioTestLayer

function CocoStudioTestLayer.extend(target)
    local t = tolua.getpeer(target)
    if not t then
        t = {}
        tolua.setpeer(target, t)
    end
    setmetatable(t, CocoStudioTestLayer)
    return target
end

function CocoStudioTestLayer.onMenuCallback(tag,sender)
    local index = sender:getZOrder() - ITEM_TAG_BASIC
    cocoStudioTestItemNames[index].testScene()
end

function CocoStudioTestLayer:createMenu()

    local winSize = CCDirector:sharedDirector():getWinSize()

    local menu = CCMenu:create()
    menu:setPosition(CCPoint(0,0))
    CCMenuItemFont:setFontName("Arial")
    CCMenuItemFont:setFontSize(24)

    for i = 1, table.getn(cocoStudioTestItemNames) do
        local menuItem = CCMenuItemFont:create(cocoStudioTestItemNames[i].itemTitle)
        menuItem:setPosition(CCPoint(winSize.width / 2, winSize.height - (i + 1) * LINE_SPACE))
        menuItem:registerScriptTapHandler(CocoStudioTestLayer.onMenuCallback)
        menu:addChild(menuItem, ITEM_TAG_BASIC + i)
    end

    self:addChild(menu)
end

function CocoStudioTestLayer.create()
    local layer = CocoStudioTestLayer.extend(CCLayer:create())

    if nil ~= layer then
        layer:createMenu()
    end 
    return layer
end

-------------------------------------
--CocoStudio Test
-------------------------------------
function CocoStudioTest()
    local newScene = CocoStudioTestScene.create()
	newScene:addChild(CreateBackMenuItem())
    newScene:addChild(CocoStudioTestLayer.create())
    newScene:runThisTest()
	return newScene
end
