/*
 * Decompiled with CFR 0.152.
 */
package com.flurry.org.codehaus.jackson.node;

import com.flurry.org.codehaus.jackson.Base64Variant;
import com.flurry.org.codehaus.jackson.Base64Variants;
import com.flurry.org.codehaus.jackson.JsonGenerator;
import com.flurry.org.codehaus.jackson.JsonLocation;
import com.flurry.org.codehaus.jackson.JsonParseException;
import com.flurry.org.codehaus.jackson.JsonProcessingException;
import com.flurry.org.codehaus.jackson.JsonToken;
import com.flurry.org.codehaus.jackson.io.NumberInput;
import com.flurry.org.codehaus.jackson.map.SerializerProvider;
import com.flurry.org.codehaus.jackson.node.ValueNode;
import com.flurry.org.codehaus.jackson.util.ByteArrayBuilder;
import com.flurry.org.codehaus.jackson.util.CharTypes;
import java.io.IOException;

public final class TextNode
extends ValueNode {
    static final int INT_SPACE = 32;
    static final TextNode EMPTY_STRING_NODE = new TextNode("");
    final String _value;

    public TextNode(String v2) {
        this._value = v2;
    }

    public static TextNode valueOf(String v2) {
        if (v2 == null) {
            return null;
        }
        if (v2.length() == 0) {
            return EMPTY_STRING_NODE;
        }
        return new TextNode(v2);
    }

    public JsonToken asToken() {
        return JsonToken.VALUE_STRING;
    }

    public boolean isTextual() {
        return true;
    }

    public String getTextValue() {
        return this._value;
    }

    public byte[] getBinaryValue(Base64Variant b64variant) throws IOException {
        ByteArrayBuilder builder = new ByteArrayBuilder(100);
        String str = this._value;
        int ptr = 0;
        int len = str.length();
        block0: while (ptr < len) {
            char ch2;
            do {
                ch2 = str.charAt(ptr++);
                if (ptr >= len) break block0;
            } while (ch2 <= ' ');
            int bits = b64variant.decodeBase64Char(ch2);
            if (bits < 0) {
                this._reportInvalidBase64(b64variant, ch2, 0);
            }
            int decodedData = bits;
            if (ptr >= len) {
                this._reportBase64EOF();
            }
            if ((bits = b64variant.decodeBase64Char(ch2 = str.charAt(ptr++))) < 0) {
                this._reportInvalidBase64(b64variant, ch2, 1);
            }
            decodedData = decodedData << 6 | bits;
            if (ptr >= len) {
                if (!b64variant.usesPadding()) {
                    builder.append(decodedData >>= 4);
                    break;
                }
                this._reportBase64EOF();
            }
            if ((bits = b64variant.decodeBase64Char(ch2 = str.charAt(ptr++))) < 0) {
                if (bits != -2) {
                    this._reportInvalidBase64(b64variant, ch2, 2);
                }
                if (ptr >= len) {
                    this._reportBase64EOF();
                }
                if (!b64variant.usesPaddingChar(ch2 = str.charAt(ptr++))) {
                    this._reportInvalidBase64(b64variant, ch2, 3, "expected padding character '" + b64variant.getPaddingChar() + "'");
                }
                builder.append(decodedData >>= 4);
                continue;
            }
            decodedData = decodedData << 6 | bits;
            if (ptr >= len) {
                if (!b64variant.usesPadding()) {
                    builder.appendTwoBytes(decodedData >>= 2);
                    break;
                }
                this._reportBase64EOF();
            }
            if ((bits = b64variant.decodeBase64Char(ch2 = str.charAt(ptr++))) < 0) {
                if (bits != -2) {
                    this._reportInvalidBase64(b64variant, ch2, 3);
                }
                builder.appendTwoBytes(decodedData >>= 2);
                continue;
            }
            decodedData = decodedData << 6 | bits;
            builder.appendThreeBytes(decodedData);
        }
        return builder.toByteArray();
    }

    public byte[] getBinaryValue() throws IOException {
        return this.getBinaryValue(Base64Variants.getDefaultVariant());
    }

    public String asText() {
        return this._value;
    }

    public boolean asBoolean(boolean defaultValue) {
        if (this._value != null && "true".equals(this._value.trim())) {
            return true;
        }
        return defaultValue;
    }

    public int asInt(int defaultValue) {
        return NumberInput.parseAsInt(this._value, defaultValue);
    }

    public long asLong(long defaultValue) {
        return NumberInput.parseAsLong(this._value, defaultValue);
    }

    public double asDouble(double defaultValue) {
        return NumberInput.parseAsDouble(this._value, defaultValue);
    }

    public final void serialize(JsonGenerator jg, SerializerProvider provider) throws IOException, JsonProcessingException {
        if (this._value == null) {
            jg.writeNull();
        } else {
            jg.writeString(this._value);
        }
    }

    public boolean equals(Object o2) {
        if (o2 == this) {
            return true;
        }
        if (o2 == null) {
            return false;
        }
        if (o2.getClass() != this.getClass()) {
            return false;
        }
        return ((TextNode)o2)._value.equals(this._value);
    }

    public int hashCode() {
        return this._value.hashCode();
    }

    public String toString() {
        int len = this._value.length();
        len = len + 2 + (len >> 4);
        StringBuilder sb = new StringBuilder(len);
        TextNode.appendQuoted(sb, this._value);
        return sb.toString();
    }

    protected static void appendQuoted(StringBuilder sb, String content) {
        sb.append('\"');
        CharTypes.appendQuoted(sb, content);
        sb.append('\"');
    }

    protected void _reportInvalidBase64(Base64Variant b64variant, char ch2, int bindex) throws JsonParseException {
        this._reportInvalidBase64(b64variant, ch2, bindex, null);
    }

    protected void _reportInvalidBase64(Base64Variant b64variant, char ch2, int bindex, String msg) throws JsonParseException {
        String base = ch2 <= ' ' ? "Illegal white space character (code 0x" + Integer.toHexString(ch2) + ") as character #" + (bindex + 1) + " of 4-char base64 unit: can only used between units" : (b64variant.usesPaddingChar(ch2) ? "Unexpected padding character ('" + b64variant.getPaddingChar() + "') as character #" + (bindex + 1) + " of 4-char base64 unit: padding only legal as 3rd or 4th character" : (!Character.isDefined(ch2) || Character.isISOControl(ch2) ? "Illegal character (code 0x" + Integer.toHexString(ch2) + ") in base64 content" : "Illegal character '" + ch2 + "' (code 0x" + Integer.toHexString(ch2) + ") in base64 content"));
        if (msg != null) {
            base = base + ": " + msg;
        }
        throw new JsonParseException(base, JsonLocation.NA);
    }

    protected void _reportBase64EOF() throws JsonParseException {
        throw new JsonParseException("Unexpected end-of-String when base64 content", JsonLocation.NA);
    }
}

