/*
 * Decompiled with CFR 0.152.
 */
package com.flurry.org.codehaus.jackson.node;

import com.flurry.org.codehaus.jackson.JsonNode;
import com.flurry.org.codehaus.jackson.JsonStreamContext;
import com.flurry.org.codehaus.jackson.JsonToken;
import com.flurry.org.codehaus.jackson.node.ContainerNode;
import com.flurry.org.codehaus.jackson.node.ObjectNode;
import java.util.Iterator;
import java.util.Map;

abstract class NodeCursor
extends JsonStreamContext {
    final NodeCursor _parent;

    public NodeCursor(int contextType, NodeCursor p2) {
        this._type = contextType;
        this._index = -1;
        this._parent = p2;
    }

    public final NodeCursor getParent() {
        return this._parent;
    }

    public abstract String getCurrentName();

    public abstract JsonToken nextToken();

    public abstract JsonToken nextValue();

    public abstract JsonToken endToken();

    public abstract JsonNode currentNode();

    public abstract boolean currentHasChildren();

    public final NodeCursor iterateChildren() {
        JsonNode n2 = this.currentNode();
        if (n2 == null) {
            throw new IllegalStateException("No current node");
        }
        if (n2.isArray()) {
            return new Array(n2, this);
        }
        if (n2.isObject()) {
            return new Object(n2, this);
        }
        throw new IllegalStateException("Current node of type " + n2.getClass().getName());
    }

    protected static final class Object
    extends NodeCursor {
        Iterator<Map.Entry<String, JsonNode>> _contents;
        Map.Entry<String, JsonNode> _current;
        boolean _needEntry;

        public Object(JsonNode n2, NodeCursor p2) {
            super(2, p2);
            this._contents = ((ObjectNode)n2).getFields();
            this._needEntry = true;
        }

        public String getCurrentName() {
            return this._current == null ? null : this._current.getKey();
        }

        public JsonToken nextToken() {
            if (this._needEntry) {
                if (!this._contents.hasNext()) {
                    this._current = null;
                    return null;
                }
                this._needEntry = false;
                this._current = this._contents.next();
                return JsonToken.FIELD_NAME;
            }
            this._needEntry = true;
            return this._current.getValue().asToken();
        }

        public JsonToken nextValue() {
            JsonToken t2 = this.nextToken();
            if (t2 == JsonToken.FIELD_NAME) {
                t2 = this.nextToken();
            }
            return t2;
        }

        public JsonToken endToken() {
            return JsonToken.END_OBJECT;
        }

        public JsonNode currentNode() {
            return this._current == null ? null : this._current.getValue();
        }

        public boolean currentHasChildren() {
            return ((ContainerNode)this.currentNode()).size() > 0;
        }
    }

    protected static final class Array
    extends NodeCursor {
        Iterator<JsonNode> _contents;
        JsonNode _currentNode;

        public Array(JsonNode n2, NodeCursor p2) {
            super(1, p2);
            this._contents = n2.getElements();
        }

        public String getCurrentName() {
            return null;
        }

        public JsonToken nextToken() {
            if (!this._contents.hasNext()) {
                this._currentNode = null;
                return null;
            }
            this._currentNode = this._contents.next();
            return this._currentNode.asToken();
        }

        public JsonToken nextValue() {
            return this.nextToken();
        }

        public JsonToken endToken() {
            return JsonToken.END_ARRAY;
        }

        public JsonNode currentNode() {
            return this._currentNode;
        }

        public boolean currentHasChildren() {
            return ((ContainerNode)this.currentNode()).size() > 0;
        }
    }

    protected static final class RootValue
    extends NodeCursor {
        JsonNode _node;
        protected boolean _done = false;

        public RootValue(JsonNode n2, NodeCursor p2) {
            super(0, p2);
            this._node = n2;
        }

        public String getCurrentName() {
            return null;
        }

        public JsonToken nextToken() {
            if (!this._done) {
                this._done = true;
                return this._node.asToken();
            }
            this._node = null;
            return null;
        }

        public JsonToken nextValue() {
            return this.nextToken();
        }

        public JsonToken endToken() {
            return null;
        }

        public JsonNode currentNode() {
            return this._node;
        }

        public boolean currentHasChildren() {
            return false;
        }
    }
}

