/*
 * Decompiled with CFR 0.152.
 */
package com.flurry.org.apache.avro.util;

import com.flurry.org.apache.avro.io.BinaryData;
import java.io.UnsupportedEncodingException;

public class Utf8
implements Comparable<Utf8>,
CharSequence {
    private static final byte[] EMPTY = new byte[0];
    private byte[] bytes = EMPTY;
    private int length;
    private String string;

    public Utf8() {
    }

    public Utf8(String string) {
        this.bytes = Utf8.getBytesFor(string);
        this.length = this.bytes.length;
        this.string = string;
    }

    public Utf8(Utf8 other) {
        this.length = other.length;
        this.bytes = new byte[other.length];
        System.arraycopy(other.bytes, 0, this.bytes, 0, this.length);
        this.string = other.string;
    }

    public Utf8(byte[] bytes) {
        this.bytes = bytes;
        this.length = bytes.length;
    }

    public byte[] getBytes() {
        return this.bytes;
    }

    public int getLength() {
        return this.length;
    }

    public int getByteLength() {
        return this.length;
    }

    public Utf8 setLength(int newLength) {
        return this.setByteLength(newLength);
    }

    public Utf8 setByteLength(int newLength) {
        if (this.length < newLength) {
            byte[] newBytes = new byte[newLength];
            System.arraycopy(this.bytes, 0, newBytes, 0, this.length);
            this.bytes = newBytes;
        }
        this.length = newLength;
        this.string = null;
        return this;
    }

    @Override
    public String toString() {
        if (this.string == null) {
            try {
                this.string = new String(this.bytes, 0, this.length, "UTF-8");
            }
            catch (UnsupportedEncodingException e2) {
                e2.printStackTrace();
            }
        }
        return this.string;
    }

    public boolean equals(Object o2) {
        if (o2 == this) {
            return true;
        }
        if (!(o2 instanceof Utf8)) {
            return false;
        }
        Utf8 that = (Utf8)o2;
        if (this.length != that.length) {
            return false;
        }
        byte[] thatBytes = that.bytes;
        int i2 = 0;
        while (i2 < this.length) {
            if (this.bytes[i2] != thatBytes[i2]) {
                return false;
            }
            ++i2;
        }
        return true;
    }

    public int hashCode() {
        int hash = 0;
        int i2 = 0;
        while (i2 < this.length) {
            hash = hash * 31 + this.bytes[i2];
            ++i2;
        }
        return hash;
    }

    @Override
    public int compareTo(Utf8 that) {
        return BinaryData.compareBytes(this.bytes, 0, this.length, that.bytes, 0, that.length);
    }

    @Override
    public char charAt(int index) {
        return this.toString().charAt(index);
    }

    @Override
    public int length() {
        return this.toString().length();
    }

    @Override
    public CharSequence subSequence(int start, int end) {
        return this.toString().subSequence(start, end);
    }

    public static final byte[] getBytesFor(String str) {
        try {
            return str.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException e2) {
            e2.printStackTrace();
            return new byte[0];
        }
    }
}

