/*
 * Decompiled with CFR 0.152.
 */
package com.flurry.org.apache.avro.file;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;

class LengthLimitedInputStream
extends FilterInputStream {
    private long remaining;

    protected LengthLimitedInputStream(InputStream in, long maxLength) {
        super(in);
        this.remaining = maxLength;
    }

    @Override
    public int read() throws IOException {
        if (this.remaining > 0L) {
            int v2 = super.read();
            if (v2 != -1) {
                --this.remaining;
            }
            return v2;
        }
        return -1;
    }

    @Override
    public int read(byte[] b2) throws IOException {
        return this.read(b2, 0, b2.length);
    }

    private int remainingInt() {
        return (int)Math.min(this.remaining, Integer.MAX_VALUE);
    }

    @Override
    public int read(byte[] b2, int off, int len) throws IOException {
        int v2;
        if (this.remaining == 0L) {
            return -1;
        }
        if ((long)len > this.remaining) {
            len = this.remainingInt();
        }
        if ((v2 = super.read(b2, off, len)) != -1) {
            this.remaining -= (long)v2;
        }
        return v2;
    }

    @Override
    public int available() throws IOException {
        return Math.min(super.available(), this.remainingInt());
    }

    @Override
    public long skip(long n2) throws IOException {
        long v2 = super.skip(Math.min(this.remaining, n2));
        this.remaining -= v2;
        return v2;
    }
}

