/*
 * Decompiled with CFR 0.152.
 */
package com.weibo.sdk.android.util;

import android.graphics.BitmapFactory;
import android.graphics.Rect;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;

public final class BitmapHelper {
    public static boolean makesureSizeNotTooLarge(Rect rect) {
        int FIVE_M = 0x500000;
        return rect.width() * rect.height() * 2 <= 0x500000;
    }

    public static int getSampleSizeOfNotTooLarge(Rect rect) {
        int FIVE_M = 0x500000;
        double ratio = (double)rect.width() * (double)rect.height() * 2.0 / 5242880.0;
        return ratio >= 1.0 ? (int)ratio : 1;
    }

    public static int getSampleSizeAutoFitToScreen(int vWidth, int vHeight, int bWidth, int bHeight) {
        if (vHeight == 0 || vWidth == 0) {
            return 1;
        }
        int ratio = Math.max(bWidth / vWidth, bHeight / vHeight);
        int ratioAfterRotate = Math.max(bHeight / vWidth, bWidth / vHeight);
        return Math.min(ratio, ratioAfterRotate);
    }

    public static boolean verifyBitmap(byte[] datas) {
        return BitmapHelper.verifyBitmap(new ByteArrayInputStream(datas));
    }

    public static boolean verifyBitmap(InputStream input) {
        if (input == null) {
            return false;
        }
        BitmapFactory.Options options = new BitmapFactory.Options();
        options.inJustDecodeBounds = true;
        input = input instanceof BufferedInputStream ? input : new BufferedInputStream(input);
        BitmapFactory.decodeStream((InputStream)input, null, (BitmapFactory.Options)options);
        try {
            input.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return options.outHeight > 0 && options.outWidth > 0;
    }

    public static boolean verifyBitmap(String path) {
        try {
            return BitmapHelper.verifyBitmap(new FileInputStream(path));
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
            return false;
        }
    }
}

